@extends('admin.layout.master')
@section('import-css')
    <link href="{{ asset('assets/admin/css/bootstrap-fileinput.css') }}" rel="stylesheet">
@stop
@section('body')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-white font-weight-bold ">
                    <h2 class="float-left"><strong>{{$page_title}}</strong></h2>
                    <a href="{{route('currency.index')}}" class="btn btn-success btn-icon float-right"><i class="fa fa-exchange-alt"></i> All Currency</a>
                </div>

                <form method="post" action="{{route('currency.update',$currency)}}" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    {{method_field('PUT')}}
                    <div class="card-body">
                        @include('errors.error')


                        <div class="row mb-3 text-uppercase">
                            <div class="form-group col-md-3">
                                <h6>Currency Name</h6>
                                <input type="text" value="{{$currency->name}}" id="name" name="name" class="form-control form-control-lg" >
                            </div>
                            <div class="form-group col-md-3">
                                <h6>Sell at</h6>
                                <input type="text" value="{{$currency->sell_at}}" id="sell_at" name="sell_at" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" >
                            </div>

                            <div class="form-group col-md-3">
                                <h6>Fixed Charge <span class="text-danger">(For Sell)</span></h6>
                                <input type="text" value="{{$currency->sell_fixed_charge}}" id="sell_fixed_charge" name="sell_fixed_charge" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" >
                            </div>
                            <div class="form-group col-md-3">
                                <h6>Percentage Charge <span class="text-danger">(For Sell)</span></h6>
                                <div class="input-group">
                                    <input type="text" value="{{$currency->sell_percentage_charge}}" id="sell_percentage_charge" name="sell_percentage_charge" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" >
                                    <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <strong>%</strong>
                                    </span>
                                    </div>
                                </div>
                            </div>



                        </div>

                        <div class="row mb-3 text-uppercase">


                            <div class="form-group col-md-3">
                                <h6>Buy at</h6>
                                <input type="text" value="{{$currency->buy_at}}" id="buy_at" name="buy_at" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" >
                            </div>
                            <div class="form-group col-md-3">
                                <h6 class="text-uppercase">Reserve Amount</h6>
                                <input type="text" value="{{$currency->reserve_amount}}" id="reserve_amount" name="reserve_amount" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                            </div>

                            <div class="form-group col-md-3">
                                <h6>Maximum Exchange</h6>
                                <input type="text" value="{{$currency->maximum_exchange}}" id="maximum_exchange" name="maximum_exchange" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" >
                            </div>
                            <div class="form-group col-md-3">
                                <h6>Minimum Exchange</h6>
                                <input type="text" value="{{$currency->minimum_exchange}}" id="minimum_exchange" name="minimum_exchange" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" >
                            </div>



                        </div>



                        <div class="row mb-3">


                            <div class="form-group col-md-6">
                                <h6 class="text-uppercase">Wallet Name</h6>
                                <input type="text" value="{{$currency->wallet_name}}" id="wallet_name" name="wallet_name" class="form-control form-control-lg" >
                            </div>
                            <div class="form-group col-md-6">
                                <h6 class="text-uppercase">Wallet Info</h6>
                                <input type="text" value="{{$currency->wallet_info}}" id="wallet_info" name="wallet_info" class="form-control form-control-lg" >
                            </div>
                        </div>


                        <div class="row mb-3">
                            <div class="form-group col-md-4">
                                <h6 class="text-uppercase">Rate Show</h6>
                                <input type="checkbox" name="status" @if($currency->status == 1) checked @endif data-style="ios" data-on="Active" data-off="DeActive" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-size="large" data-width="100%">
                            </div>
                            <div class="form-group col-md-4">
                                <h6 class="text-uppercase">Available For Buy</h6>
                                <input type="checkbox" name="buy_status"  @if($currency->buy_status == 1) checked @endif data-style="ios" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-size="large" data-width="100%">
                            </div>
                            <div class="form-group col-md-4">
                                <h6 class="text-uppercase">Available For Sell</h6>
                                <input type="checkbox" name="sell_status"  @if($currency->sell_status == 1) checked @endif data-style="ios" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-size="large" data-width="100%">
                            </div>
                        </div>


                        <div class="row mt-3">
                            <div class="form-group col-md-12">
                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                    <div class="fileinput-new thumbnail"
                                         style="width: 200px; height: 200px;">
                                        @if($currency->image == null)
                                        <img src="https://via.placeholder.com/150.png?text=Image" alt="*"/>
                                        @else
                                            <img src="{{asset('assets/images/currency/'.$currency->image)}}" alt="*">
                                            @endif
                                    </div>
                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                         style="max-width: 200px; max-height: 200px;"></div>
                                    <div>
                                                        <span class="btn btn-success btn-file">
                                                            <span class="fileinput-new"> Change Image </span>
                                                            <span class="fileinput-exists"> Change </span>
                                                            <input type="file" name="image"> </span>
                                        <a href="javascript:;" class="btn btn-danger fileinput-exists"
                                           data-dismiss="fileinput"> Remove </a>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>

                    <div class="card-footer bg-white">
                        <button class="btn btn-primary btn-block btn-lg">Update Currency</button>
                    </div>
                </form>

            </div>
        </div>
    </div>


@endsection

@section('import-script')
    <script src="{{ asset('assets/admin/js/bootstrap-fileinput.js') }}"></script>
@stop